<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreSezioneSdoppiata extends VisualizzatoreComponente {
        private $impostazioniAspetto;
        private $altezzaSezione;
        
        function __construct($db) {
            parent::__construct($db);
            $this->impostazioniAspetto = parent::getDb()->leggiSingolaRiga("geecB_impostazioni",1);
        }

        function creaSezione($dati) {
            $this->generaContenutoSezione($dati); 
        }

        function generaContenutoSezione($dati) {
            $codiceColore = "";
            
            if($dati["coloreSfondo"]!="") {
                $codiceColore = "style=\"background-color:{$dati["coloreSfondo"]};\"";
            }
            
            $sezione = parent::getDb()->leggiSingolaRiga("geec_sezioniSdoppiate",$dati["idElemento"]);
            $this->altezzaSezione = $sezione["altezza"]; //TODO mettere questo parametro da backend
            echo"<section id=\"{$dati["idSezione"]}\" class=\"doppia-colonna {$dati["classeSezione"]}\" $codiceColore>";
            $linkImmagine = $this->impostazioniAspetto["urlSito"]."/".$sezione["immagine"];
            
            if($dati["aTuttaLarghezza"]!="si") {
                echo"<div class=\"container\">";
            }
            
            $classiOrdinamento        = $this->generaClassiOrdinamento("mobile", $sezione["doveSiTrovaImmagineSuMobile"]);
            $classiOrdinamentoDesktop = $this->generaClassiOrdinamento("desktop", $sezione["doveSiTrovaImmagine"]);

            $classiOrdinamento["classeDivImmagine"] .= " ".$classiOrdinamentoDesktop["classeDivImmagine"];
            $classiOrdinamento["classeDivTesto"]    .= " ".$classiOrdinamentoDesktop["classeDivTesto"];

            // in caso si usa parallax e l'immagine è spostata a sinistra, va aggiunto questo codice
            if($sezione["doveSiTrovaImmagine"]=="sinistra" && $sezione["usaParallax"]=="si") {
                $classiOrdinamento["classeDivTesto"] .= " ml-md-auto";
            }
            
            // a seconda delle opzioni selezionate stampo il contenuto della sezione
            if($sezione["stileImmagine"]=="Immagine di sfondo") {
                $this->stampaSezione($sezione,$linkImmagine,$classiOrdinamento);
            }
            else if($sezione["stileImmagine"]=="Contenuta in un tag img") {
                $this->stampaSezioneConImmagineTagImg($sezione,$linkImmagine,$classiOrdinamento);
            }
            
            if($dati["aTuttaLarghezza"]!="si") {
                echo"</div>";
            }
            echo"</section>";
        }
        
        function stampaSezione($sezione,$linkImmagine,$classiOrdinamento) {
            $classiDiv = explode(", ", $sezione["proporzioni"]);
            $classiAggiuntiveParallax = ($sezione["usaParallax"]=="si") ? "jarallax" : "";
            $stileDivSezione          = ($sezione["usaParallax"]=="si") ? "style=\"background-image:url('$linkImmagine')\"" : "";
            ?>
            <div class="row no-gutters <?= $classiAggiuntiveParallax ?>" <?= $stileDivSezione ?> >
                <div class=" <?= $sezione["spazioOccupato"] ?>">
                    <div class="row">
                        <div class="<?= $classiDiv[0] ?> d-flex align-items-center justify-content-center <?= $this->altezzaSezione ?> text-col <?= $sezione["classeDivTesto"]." ".$classiOrdinamento["classeDivTesto"] ?>" style="background-color:<?= $sezione["coloreDivTesto"] ?>">
                            <div class="p-5" data-aos="<?= $sezione["animazioneTesto"] ?>"> 
                                <?= $sezione["testo"] ?>
                            </div>
                        </div>
                        <?php
                            if($sezione["usaParallax"]=="no") {
                                echo"<div class=\"{$classiDiv[1]} background-image d-flex align-items-center justify-content-center $this->altezzaSezione {$sezione["classeDivImmagine"]} {$classiOrdinamento["classeDivImmagine"]}\" style=\"background-image: url('$linkImmagine')\" data-aos=\"{$sezione["animazioneImmagine"]}\"></div>";
                            }
                        ?>
                    </div>
                </div>
            </div>
            <?php
        }
        
        function stampaSezioneConImmagineTagImg($sezione,$linkImmagine,$classiOrdinamento) {
            $classiDiv = explode(", ", $sezione["proporzioni"]);
            ?>
            <div class="row">
                <div class=" <?= $sezione["spazioOccupato"] ?>">
                    <div class="row">
                        <div class="<?= $classiDiv[0] ?> d-flex align-items-center justify-content-center <?= $this->altezzaSezione ?> text-col <?= $sezione["classeDivTesto"]." ".$classiOrdinamento["classeDivTesto"] ?>" style="background-color:<?= $sezione["coloreDivTesto"] ?>">
                            <div class="" data-aos="<?= $sezione["animazioneTesto"] ?>"> 
                                <?= $sezione["testo"] ?>
                            </div>
                        </div>
                        <div class="<?= $classiDiv[1]." ".$sezione["classeDivImmagine"]." ".$classiOrdinamento["classeDivImmagine"] ?>" data-aos="<?= $sezione["animazioneImmagine"] ?>"><img class="img-fluid w-100" src="<?= $linkImmagine ?>" alt="<?= $sezione["tagAltImmagine"] ?>"></div>
                    </div>
                </div>
            </div>
            <?php
        }
        
        /**
         * Metodo che genrea l'ordinamento delle classi. La variabile $valoreDaControllare
         * contiene il valore con cui stabilire se deve essere mostrata prima l'immagine o prima il testo
         * 
         * Per il mobile i valori ammessi sono "Sopra il testo"  e "Sotto il testo", per il desktop sono "sinistra" e "destra"
         * 
         * se la variabile  $doveSiTrovaImmagine ha valore "Sopra il testo" oppure "sinistra", deve allora deve essere mostrata
         * prima l'immagine, altrimenti il contrario
         */
        function generaClassiOrdinamento($tipoDispositivo,$doveSiTrovaImmagine) {
            $classeOrdinamento   = ($tipoDispositivo=="mobile") ? "order" : "order-md";
            $valoreDaControllare = ($tipoDispositivo=="mobile") ? "Sopra il testo" : "sinistra";
            
            $classiOrdinamento = [];
            if($doveSiTrovaImmagine == $valoreDaControllare) {
                $classiOrdinamento["classeDivImmagine"] = "$classeOrdinamento-0";
                $classiOrdinamento["classeDivTesto"]    = "$classeOrdinamento-1";
            }
            else {
                $classiOrdinamento["classeDivImmagine"] = "$classeOrdinamento-1";
                $classiOrdinamento["classeDivTesto"]    = "$classeOrdinamento-0";              
            }
            
            return $classiOrdinamento;
        }
    }